<?php

namespace App\Actions\V1\Project;

use App\Dto\V1\Project\ProjectImagesDto;
use App\Models\ProjectImage;

readonly class UploadImagesAction
{
    public function execute(ProjectImagesDto $dto): array
    {
        $images = [];
        foreach ($dto->uploadImagesPayload() as $imageData) {
            $images[] = ProjectImage::query()->create($imageData);
        }
        return $images;
    }
}