<?php

namespace App\Actions\V1\Project;

use App\Dto\V1\Project\ProjectImageDto;
use App\Models\ProjectImage;
use App\Repositories\V1\Projects\ProjectImageRepositoryInterface;
use Illuminate\Support\Collection;

readonly class UploadImageAction
{
    public function __construct(private ProjectImageRepositoryInterface $projectImageRepository)

    {
    }

    public function execute(ProjectImageDto $dto): Collection
    {
        return $this->projectImageRepository->create($dto->uploadImagePayload());
    }
}
