<?php

namespace App\Actions\V1\Project;

use App\Dto\V1\Project\ProjectDto;
use App\Models\User;
use App\Repositories\V1\Projects\ProjectImageRepositoryInterface;
use App\Repositories\V1\Projects\ProjectRepositoryInterface;

readonly class StoreBulkProjectAction
{
    public function __construct(
        private ProjectRepositoryInterface $projectRepository,
        private ProjectImageRepositoryInterface $projectImageRepository
    )
    {
    }

    public function execute(array $projectsData, User $user): void
    {
        foreach ($projectsData as $projectData) {
            $dto = new ProjectDto(
                nameEn: $projectData['name_en'],
                nameAr: $projectData['name_ar'],
                descriptionEn: $projectData['description_en'],
                descriptionAr: $projectData['description_ar'],
                type: $projectData['type'],
                images: $projectData['images'],
                areaEn: $projectData['area_en'],
                areaAr: $projectData['area_ar'],
                countryId: $projectData['country_id'] ?? null,
                stateId: $projectData['state_id'] ?? null,
                cityId: $projectData['city_id'] ?? null,
                projectTypeId: $projectData['project_type_id'] ?? null,
                designTypeId: $projectData['design_type_id'] ?? null,
                budgetId: $projectData['budget_id'] ?? null,
                categoryId: $projectData['category_id'] ?? null
            );

            $project = $this->projectRepository->store($dto->projectStorePayload($user->id));
            $this->projectImageRepository->assignImages($project->id, $dto->images);
        }
    }
}