<?php

namespace App\Actions\V1\Project;

use App\Repositories\V1\Projects\ProjectRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

readonly class GetSimilarProjectsAction
{
    public function __construct(private ProjectRepositoryInterface $projectRepository)
    {
    }

    public function execute(int $id, int $categoryId, int $limit): LengthAwarePaginator
    {
            if (!$categoryId) {
                throw new \InvalidArgumentException('Category ID must not be null.');
            }
        return $this->projectRepository->getSimilarProjectByCategoryId($id, $categoryId, $limit);
    }
}
