<?php

namespace App\Actions\V1\Project;

use App\Repositories\V1\Projects\ProjectLikeRepositoryInterface;

readonly class GetProjectLikesCountAction
{
    public function __construct(private ProjectLikeRepositoryInterface $likeRepository)
    {
    }

    public function execute(int $projectId): int
    {
        return $this->likeRepository->countByProject($projectId);
    }
}
