<?php

namespace App\Actions\V1\Project;

use App\Enums\Project\ProjectStatusEnum;
use App\Models\Project;
use App\Repositories\V1\Projects\ProjectRepositoryInterface;

readonly class GetProjectDetailsAction
{
    public function __construct(private ProjectRepositoryInterface $projectRepository)
    {
    }

    public function execute(int $id): Project
    {
        return $this->projectRepository->getProjectWithDetails($id, ['status' => ProjectStatusEnum::PUBLISHED->value]);
    }
}
