<?php

namespace App\Actions\V1\Project;

use App\Repositories\V1\Projects\ProjectImageRepositoryInterface;
use Illuminate\Database\Eloquent\ModelNotFoundException;

readonly class DeleteProjectImageAction
{
    public function __construct(private ProjectImageRepositoryInterface $projectImageRepository)
    {
    }

    public function execute(int $id, int $userId): void
    {
        $image = $this->projectImageRepository->first($id);
        if (!$image || $image->project->user_id != $userId) {
            throw new ModelNotFoundException(__('exceptions.image_not_fount'));
        }

        $this->projectImageRepository->delete($id);
    }
}
