<?php

namespace App\Actions\V1\Project;

use App\Dto\V1\Project\ProjectDto;
use App\Enums\Project\ProjectStatusEnum;
use App\Exceptions\LogicalException;
use App\Repositories\V1\Projects\ProjectRepositoryInterface;
use Illuminate\Database\Eloquent\ModelNotFoundException;

readonly class ChangeProjectStatusAction
{
    public function __construct(private ProjectRepositoryInterface $projectRepository)
    {
    }

    /**
     * @throws LogicalException
     */
    public function execute(int $projectId, ProjectDto $dto, int $userId): void
    {
        $project = $this->projectRepository->first($projectId);
        if (!$project || $project->user_id != $userId) {
            throw new ModelNotFoundException(__('exceptions.project_not_found'));
        }

        if (in_array($project->status, [ProjectStatusEnum::notReadyToPublishStatus()])) {
            throw new LogicalException(__('exceptions.can_not_change_status'));
        }

        $this->projectRepository->update($projectId, $dto->changeStatusPayload());
    }
}
