<?php

namespace App\Actions\V1\Labels;

use App\Dto\V1\LabelDto;
use App\Repositories\V1\Labels\LabelRepositoryInterface;

readonly class UpdateLabelAction
{
    public function __construct(private LabelRepositoryInterface $repository)
    {
    }

    public function execute(LabelDto $dto, int $id): bool
    {
        return $this->repository->update($id, $dto->updatePayload());
    }
}
