<?php

namespace App\Actions\V1\Labels;

use App\Models\Label;
use App\Repositories\V1\Labels\LabelRepositoryInterface;

readonly class GetLabelAction
{
    public function __construct(private LabelRepositoryInterface $repository)
    {
    }

    public function execute(int $id): Label
    {
        return $this->repository->getById($id);
    }
}
