<?php

namespace App\Actions\V1\InternalUsers;

use App\Dto\V1\InternalUserDto;
use App\Models\InternalUser;
use App\Repositories\V1\InternalUsers\InternalUserRepositoryInterface;
use App\Repositories\V1\Roles\PermissionRepositoryInterface;

readonly class UpdateInternalUserAction
{
    public function __construct(private InternalUserRepositoryInterface $internalUserRepository,
                                private PermissionRepositoryInterface   $permissionRepository)
    {
    }

    public function execute(InternalUserDto $dto, int $id): InternalUser
    {
        $this->internalUserRepository->update($id, $dto->updateUserPayload());
        $roles = $this->permissionRepository->getRolesByIds($dto->roleIds);

        $user = $this->internalUserRepository->getById($id);
        $user->syncRoles($roles);
        return $user;
    }
}
