<?php

namespace App\Actions\V1\InternalUsers;

use App\Dto\V1\InternalUserDto;
use App\Models\InternalUser;
use App\Repositories\V1\InternalUsers\InternalUserRepositoryInterface;
use App\Repositories\V1\Roles\PermissionRepositoryInterface;

readonly class StoreInternalUserAction
{
    public function __construct(private InternalUserRepositoryInterface $internalUserRepository,
                                private PermissionRepositoryInterface   $permissionRepository)
    {
    }

    public function execute(InternalUserDto $dto): InternalUser
    {
        $user = $this->internalUserRepository->create($dto->createUserPayload());
        $roles = $this->permissionRepository->getRolesByIds($dto->roleIds);
        $user->syncRoles($roles);
        return $user;
    }
}
