<?php

namespace App\Actions\V1\InternalUsers;

use App\Repositories\V1\InternalUsers\InternalUserRepositoryInterface;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class InternalUserListAction
{
    public function __construct(private InternalUserRepositoryInterface $internalUserRepository)
    {
    }

    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->internalUserRepository->index($utility, $limit);
    }
}
