<?php

namespace App\Actions\V1\FooterTitles;

use App\Repositories\V1\Footers\FooterTitleRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;
use Infrastructure\Services\Utilities\Footers\FooterTitlesUtility;


readonly class FooterTitleListAction
{
    public function __construct(private FooterTitleRepositoryInterface $repository)
    {
    }
    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->index($utility, $limit);
    }
    public function executeAll(FooterTitlesUtility $utility)
    {
        return $this->repository->indexAll($utility);
    }

}
