<?php

namespace App\Actions\V1\FooterTitleDetails;

use App\Dto\V1\FooterTitleDetailDto;
use App\Repositories\V1\Footers\FooterTitleDetailRepositoryInterface;

readonly class UpdateFooterTitleDetailAction
{
    public function __construct(private FooterTitleDetailRepositoryInterface $repository)
    {
    }

    public function execute(FooterTitleDetailDto $dto, int $id): bool
    {
        return $this->repository->update($id, $dto->updatePayload());
    }
}
