<?php

namespace App\Actions\V1\Currencies;

use App\Dto\V1\CurrencyDto;
use App\Repositories\V1\Currencies\CurrencyRepositoryInterface;

readonly class UpdateCurrencyAction
{
    public function __construct(private CurrencyRepositoryInterface $repository)
    {
    }

    public function execute(CurrencyDto $dto, int $id): bool
    {
        return $this->repository->update($id, $dto->updatePayload());
    }
}
