<?php

namespace App\Actions\V1\Currencies;

use App\Dto\V1\CurrencyDto;
use App\Models\Currency;
use App\Repositories\V1\Currencies\CurrencyRepositoryInterface;

readonly class StoreCurrencyAction
{
    public function __construct(private CurrencyRepositoryInterface $repository)
    {
    }

    public function execute(CurrencyDto $dto): Currency
    {
        return $this->repository->create($dto->createPayload());
    }
}
