<?php

namespace App\Actions\V1\Currencies;

use App\Models\Currency;
use App\Repositories\V1\Currencies\CurrencyRepositoryInterface;

readonly class GetCurrencyAction
{
    public function __construct(private CurrencyRepositoryInterface $repository)
    {
    }

    public function execute(int $id): Currency
    {
        return $this->repository->getById($id);
    }
}
