<?php

namespace App\Actions\V1\Countries;

use App\Dto\V1\CountryDto;
use App\Models\Country;
use App\Repositories\V1\Countries\CountryRepositoryInterface;

readonly class StoreCountryAction
{
    public function __construct(private CountryRepositoryInterface $repository) {}

    public function execute(CountryDto $dto): Country
    {
        return $this->repository->create($dto->createPayload());
    }
}