<?php

namespace App\Actions\V1\Countries;

use App\Models\Country;
use App\Repositories\V1\Countries\CountryRepositoryInterface;

readonly class GetCountryAction
{
    public function __construct(private CountryRepositoryInterface $repository) {}

    public function execute(int $id): Country
    {
        return $this->repository->getById($id);
    }
}
