<?php

namespace App\Actions\V1\Contacts;

use App\Dto\V1\ContactDto;
use App\Models\Contact;
use App\Repositories\V1\Contacts\ContactRepositoryInterface;

readonly class UpdateContactAction
{
    public function __construct(private ContactRepositoryInterface $repository)
    {
    }

    public function execute(ContactDto $dto, int $id): Contact
    {
        $this->repository->update($id, $dto->createPayload());

        return $this->repository->getById($id);
    }
}

