<?php

namespace App\Actions\V1\Contacts;

use App\Dto\V1\ContactDto;
use App\Models\Contact;
use App\Repositories\V1\Contacts\ContactRepositoryInterface;

readonly class StoreContactAction
{
    public function __construct(private ContactRepositoryInterface $repository)
    {
    }

    public function execute(ContactDto $dto): Contact
    {
        return $this->repository->create($dto->createPayload());
    }
}

