<?php

namespace App\Actions\V1\Contacts;

use App\Models\Contact;
use App\Repositories\V1\Contacts\ContactRepositoryInterface;

readonly class GetContactAction
{
    public function __construct(private ContactRepositoryInterface $repository)
    {
    }

    public function execute(int $id): Contact
    {
        return $this->repository->getById($id);
    }
}

