<?php

namespace App\Actions\V1\Cities;

use App\Models\City;
use App\Repositories\V1\Cities\CityRepositoryInterface;

readonly class GetCityAction
{
    public function __construct(private CityRepositoryInterface $repository)
    {
    }

    public function execute(int $id): City
    {
        return $this->repository->getById($id);
    }
}
