<?php

namespace App\Actions\V1\Cities;

use App\Repositories\V1\Cities\CityRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Cities\CitiesUtility;
use Illuminate\Pagination\LengthAwarePaginator;

readonly class CityListAction
{
    public function __construct(private CityRepositoryInterface $repository)
    {
    }

    public function execute(CitiesUtility $utility): Collection
    {
        return $this->repository->index($utility);
    }

    public function executeWithPagination(CitiesUtility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->indexPaginated($utility, $limit);
    }
}
