<?php

namespace App\Actions\V1\Categories;

use App\Dto\V1\CategoryDto;
use App\Repositories\V1\Categories\CategoryRepositoryInterface;

readonly class ChangeCategoryStatusAction
{
    public function __construct(private CategoryRepositoryInterface $categoryRepository)
    {
    }

    public function execute(CategoryDto $dto, int $id): bool
    {
        return $this->categoryRepository->update($id, $dto->changeStatusPayload());
    }
}
