<?php

namespace App\Actions\V1\Categories;

use App\Repositories\V1\Categories\CategoryRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class CategoryListAction
{
    public function __construct(private CategoryRepositoryInterface $categoryRepository)
    {
    }
    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->categoryRepository->index($utility, $limit);
    }
}
