<?php

namespace App\Actions\V1\Blog;

use App\Models\Blog;
use App\Repositories\V1\Blogs\BlogRepositoryInterface;
use Illuminate\Support\Collection;

readonly class GetBlogWithRelatedAction
{
    public function __construct(private BlogRepositoryInterface $repository)
    {
    }

    public function execute(int $id, int $relatedLimit = 6): array
    {
        $blog = $this->repository->getById($id);
        $related = $this->repository->related($blog->id, $relatedLimit);

        return [
            'blog' => $blog,
            'related' => $related,
        ];
    }
}