<?php

namespace App\Actions\V1\Blog;

use App\Repositories\V1\Blogs\BlogImageRepositoryInterface;
use Illuminate\Database\Eloquent\ModelNotFoundException;

readonly class DeleteBlogImageAction
{
    public function __construct(private BlogImageRepositoryInterface $blogImageRepository)
    {
    }

    public function execute(int $id): void
    {
        $image = $this->blogImageRepository->first($id);
        if (!$image) {
            throw new ModelNotFoundException(__('exceptions.image_not_fount'));
        }

        $this->blogImageRepository->delete($id);
    }
}

