<?php

namespace App\Actions\V1\Blog;

use App\Repositories\V1\Blogs\BlogRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

readonly class BlogListAction
{
    public function __construct(private BlogRepositoryInterface $repository)
    {
    }

    public function execute(int $limit): LengthAwarePaginator
    {
        return $this->repository->index($limit);
    }
}

