<?php

namespace Infrastructure\Services\Utilities\Users\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class PhoneFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('phone', '=', $value);
    }

    public static function key(): string
    {
        return 'phone';
    }
}
