<?php

namespace Infrastructure\Services\Utilities\States\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class CountryIdFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('country_id', '=', $value);
    }

    public static function key(): string
    {
        return 'country_id';
    }
}