<?php

namespace Infrastructure\Services\Utilities\Roles\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class NameFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('name', 'like', '%' . $value . '%');
    }

    public static function key(): string
    {
        return 'name';
    }
}
