<?php

namespace Infrastructure\Services\Utilities\Projects\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class StatusFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        if ($value === '0' || $value === 0) {
            $builder->where('home_status', 0);
            return;
        }

        if ($value === '1' || $value === 1) {
            $builder->where('home_status', 1);
        }
    }

    public static function key(): string
    {
        return 'home_status';
    }
}