<?php

namespace Infrastructure\Services\Utilities\Projects\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class StateIdFilter implements UtilityInterface
{
    public static function key(): string
    {
  
        return 'stateId';
    }

    public static function query(Builder $builder, mixed $value): void
    {
        if (!$value) {
            return;
        }

        $builder->where('state_id', (int) $value);
    }
}