<?php

namespace Infrastructure\Services\Utilities\InternalUsers\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class EmailFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('email', 'like', '%' . $value . '%');
    }

    public static function key(): string
    {
        return 'email';
    }
}
