<?php

namespace Infrastructure\Services\Utilities\GeneralFilters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class NameFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('name_en', 'like', '%' . $value . '%')
            ->orWhere('name_ar', 'like', '%' . $value . '%');
    }

    public static function key(): string
    {
        return 'name';
    }
}
