<?php

use App\Enums\UserTypeEnum;
use App\Http\Controllers\V1\{LikeController, ProjectController};

Route::middleware(['auth:sanctum', 'abilities:' . UserTypeEnum::PROFESSIONAL->name])->group(function () {
    Route::post('store', [ProjectController::class, 'storeProject']);
    Route::delete('image/{id}', [ProjectController::class, 'deleteImage']);
    Route::post('update/{id}', [ProjectController::class, 'updateProject']);
    Route::post('change-status/{id}', [ProjectController::class, 'changeStatus']);
    Route::post('upload-image', [ProjectController::class, 'uploadImage']);
    Route::post('change-status/{id}', [ProjectController::class, 'changeStatus']);
    Route::post('bulk', [ProjectController::class, 'storeBulk']);
    Route::post('upload-images', [ProjectController::class, 'uploadImages']);

});

Route::middleware(['auth:sanctum', 'ability:' . UserTypeEnum::PROFESSIONAL->name . ',' . UserTypeEnum::CUSTOMER->name])->group(function () {
    

    Route::post('/{id}/comments', [ProjectController::class, 'storeComment']);
    Route::put('/{id}/like', [LikeController::class, 'toggleLike']);
    Route::get('/liked', [ProjectController::class, 'getisliked']);
    Route::get('/liked/{id}', [ProjectController::class, 'getProjectDetailsFromLikes']);
});

Route::get('/{id}/likes/count', [LikeController::class, 'likesCount']);
Route::get('/{id}/comments', [ProjectController::class, 'getProjectComments']);

