<?php

use App\Http\Controllers\V1\ProjectController;
use App\Http\Controllers\Website\AuthController;
use App\Http\Controllers\Website\PropertyRequirementController;

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\V1\ServiceController;
use App\Http\Controllers\V1\{CategoryController,
    CityController,
    FooterTitleController,
    FooterTitleDetailController,
    LabelController,
    SettingController,
    SliderController,
    StateController,
    TagController,
    CountryController,
    SubCategoryController,
    LikeController,
    NewsletterController,
};

 Route::get('/v1/category-all', [CategoryController::class, 'all']);
 Route::get('/v1/sub_categories-all', [SubCategoryController::class, 'all']);

Route::prefix('v1/auth')->group(base_path('routes/api/v1/auth.php'));

Route::middleware('auth:sanctum')->group(function () {
    Route::prefix('v1/projects')->group(base_path('routes/api/v1/projects.php'));
    Route::prefix('v1')->group(base_path('routes/api/v1/contact_us.php'));

        Route::prefix('v1/newsletter')->group(function () {
    Route::get('/', [NewsletterController::class, 'index']);

    Route::get('/{id}', [NewsletterController::class, 'show']);         
  
});
   
   
   
    Route::prefix('v1/property-requirements')->group(function () {
            Route::get('/', [PropertyRequirementController::class, 'index']); // list
            Route::get('/{id}', [PropertyRequirementController::class, 'show']); // show
            Route::patch('/{id}/change-status', [PropertyRequirementController::class, 'updateStatus']); // update status
            
                Route::delete('/{id}', [PropertyRequirementController::class, 'destroy']); 

        });
    
    Route::prefix('v1/projects-auth')->controller(ProjectController::class)->group(function () {
    Route::get('/', 'indexwithauth');
    Route::get('/{id}', 'getProjectDetailswithauth');
    Route::delete('/{id}', [ProjectController::class, 'destroy']);

});

    Route::prefix('v1/roles')->group(base_path('routes/api/v1/roles.php'));
    Route::prefix('v1/internal-users')->group(base_path('routes/api/v1/internal_users.php'));
    Route::prefix('v1/users')->group(base_path('routes/api/v1/users.php'));
    Route::prefix('v1/blogs')->group(base_path('routes/api/v1/blogs.php'));
    Route::prefix('v1')->group(base_path('routes/api/v1/routes.php'));
    Route::prefix('v1/lookups')->group(base_path('routes/api/v1/lookups.php'));
    Route::prefix('v1/home')->group(base_path('routes/api/v1/home.php'));
    Route::prefix('v1/sub-categories')->group(
        base_path('routes/api/v1/sub_categories.php')
    );
    Route::prefix('v1/services')->group(base_path('routes/api/v1/services.php'));
});
Route::prefix('v1/projects')->controller(ProjectController::class)->group(function () {
    Route::get('/', 'index');
    Route::get('/{id}', 'getProjectDetails');
});
Route::prefix('v1/blogs')->controller(\App\Http\Controllers\V1\BlogController::class)->group(function () {
    Route::get('/', 'indexnotauth');
    Route::get('/{id}', 'getByIdnotauth');
});


Route::get('v1/services-notauth/', [ServiceController::class, 'indexnotauth']);
Route::get('v1/services-notauth/{id}', [ServiceController::class, 'shownotauth']);

 Route::prefix('v1/countries-notauth')->group(function () {
        Route::get('/', [CountryController::class, 'indexnotauth']); 
        Route::get('/{id}', [CountryController::class, 'getByIdnotauth']);
        
 });
  Route::prefix('v1/states-notauth')->group(function () {
        Route::get('/', [StateController::class, 'indexnotauth']); 
        Route::get('/{id}', [StateController::class, 'getByIdnotauth']);
        
 });
  Route::prefix('v1/cities-notauth')->group(function () {
        Route::get('/', [CityController::class, 'indexnotauth']); 
        Route::get('/{id}', [CityController::class, 'getByIdnotauth']);
        
 });
 
 Route::prefix('v1/categories-notauth')->group(function () {
    Route::get('/', [CategoryController::class, 'indexnotauth']);
    Route::get('/{id}', [CategoryController::class, 'getByIdnotauth']);
 });
 
 
 Route::prefix('v1/sub_categories-notauth')->group(function () {

Route::get('/', [SubCategoryController::class, 'indexnotauth']);
Route::get('{id}', [SubCategoryController::class, 'getByIdnotauth']);
});

Route::prefix('v1/sliders-notauth')->group(function () {
    Route::get('/', [SliderController::class, 'indexnotauth']);
    Route::get('/{id}', [SliderController::class, 'getByIdnotauth']);
});


Route::prefix('v1/settings-notauth')->group(function () {
    Route::get('/', [SettingController::class, 'indexnotauth']);
    Route::get('/{id}', [SettingController::class, 'getByIdnotauth']);
    
});


//Footer Title
Route::prefix('v1/footer-titles-notauth')->group(function () {
    Route::get('/', [FooterTitleController::class, 'indexnotauth']);
    Route::get('/{id}', [FooterTitleController::class, 'getByIdnotauth']);
});

//Footer Title Detail
Route::prefix('v1/footer-title-details-notauth')->group(function () {
    Route::get('/', [FooterTitleDetailController::class, 'indexnotauth']);
    Route::get('/{id}', [FooterTitleDetailController::class, 'getByIdnotauth']);

});





//website routes

Route::prefix('website')->group(function () {
    Route::post('/newsletter', [NewsletterController::class, 'store']);
    Route::post('login', [AuthController::class, 'login']);
    Route::post('register', [AuthController::class, 'register']);
    

    Route::middleware('auth:sanctum')->group(function () {
        
          Route::post('property-requirements', [PropertyRequirementController::class, 'store']);
       
        Route::post('logout', [AuthController::class, 'logout']);
        
         Route::put('/{id}/like', [LikeController::class, 'toggleLike']);
         
         Route::get('/liked', [ProjectController::class, 'getisliked']);
         
          Route::get('auth-user', [AuthController::class, 'authUser']);

        Route::post('update-profile', [AuthController::class, 'updateProfile']);

        Route::post('update-password', [AuthController::class, 'updatePassword']);
    });
});
