<?php

use Illuminate\Contracts\Console\Kernel;

require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';

$kernel = $app->make(Kernel::class);

try {
    // نشغّل Seeder اللي إنت بعته بالاسم
    $kernel->call('db:seed', [
        '--class' => 'Database\\Seeders\\PermissionsTableSeeder',
        '--force' => true
    ]);

    echo "✅ PermissionsTableSeeder executed successfully 😎<br>";
    echo "<pre>" . $kernel->output() . "</pre>";
} catch (Throwable $e) {
    http_response_code(500);
    echo "❌ Error while seeding: " . $e->getMessage();
}
