<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->unsignedBigInteger('country_id')->nullable()->after('id');
            $table->unsignedBigInteger('sub_category_id')->nullable()->after('country_id');
            $table->string('tiktok_link')->nullable()->after('sub_category_id');
        });
    }

    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropForeign(['country_id']);
            $table->dropForeign(['sub_category_id']);
            $table->dropColumn(['country_id', 'sub_category_id', 'tiktok_link']);
        });
    }
};
