<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tags', function (Blueprint $table) {
            $table->id();
            $table->string('name_en');
            $table->string('name_ar');
            $table->boolean('status')->default(0)->comment('0 - Inactive, 1 - Active');
            $table->string('icon')->nullable();
            $table->timestamps();
        });

        \App\Models\Tag::query()->insert($this->data());
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tags');
    }

    public function data(): array
    {
        return [
            ['name_en' => 'Certified by Bnaia', 'name_ar' => 'معتمد من بناية', 'status' => 1],
            ['name_en' => 'Good listener', 'name_ar' => 'مستمع جيد', 'status' => 1],
            ['name_en' => 'Speed of response', 'name_ar' => 'سرعة الرد', 'status' => 1],
            ['name_en' => 'On time delivery', 'name_ar' => 'التسليم في الموعد', 'status' => 1]
        ];
    }
};
