<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('name_en');
            $table->string('name_ar');
            $table->boolean('status')->default(0)->comment('0 - Inactive, 1 - Active');
            $table->timestamps();
        });

        \App\Models\Category::query()->insert($this->data());
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }

    public function data(): array
    {
        return [
            ['name_en' => 'Engineering offices', 'name_ar' => 'مكاتب هندسية', 'status' => 1],
            ['name_en' => 'Equipment and machines', 'name_ar' => 'معدات وآلات', 'status' => 1],
            ['name_en' => 'Furniture and furnishings', 'name_ar' => 'اثاث وفرش', 'status' => 1],
            ['name_en' => 'Smart Home', 'name_ar' => 'سمارت هوم', 'status' => 1],
            ['name_en' => 'Industrial and technical', 'name_ar' => 'صنايعى وفنى', 'status' => 1],
            ['name_en' => 'Design and finishing', 'name_ar' => 'تصميم وتشطيب', 'status' => 1]
        ];
    }
};
