<?php

return [

    'defaults' => [
        'guard' => env('AUTH_GUARD', 'web'), // Default = InternalUser
        'passwords' => env('AUTH_PASSWORD_BROKER', 'users'),
    ],

    'guards' => [

        // Admin Panel (Internal Users) - Session
        'web' => [
            'driver' => 'session',
            'provider' => 'internal_users',
        ],

        // Admin Panel / InternalUser - API (Sanctum)
        'internal_sanctum' => [
            'driver' => 'sanctum',
            'provider' => 'internal_users',
        ],

        // Website / API Users
        'website' => [
            'driver' => 'sanctum',
            'provider' => 'users',
        ],

    ],

    'providers' => [

        'internal_users' => [
            'driver' => 'eloquent',
            'model' => App\Models\InternalUser::class,
        ],

        'users' => [
            'driver' => 'eloquent',
            'model' => App\Models\User::class,
        ],

    ],

    'passwords' => [

        'internal_users' => [
            'provider' => 'internal_users',
            'table' => env('AUTH_PASSWORD_RESET_TOKEN_TABLE', 'password_reset_tokens'),
            'expire' => 60,
            'throttle' => 60,
        ],

        'users' => [
            'provider' => 'users',
            'table' => env('AUTH_PASSWORD_RESET_TOKEN_TABLE', 'password_reset_tokens'),
            'expire' => 60,
            'throttle' => 60,
        ],

    ],

    'password_timeout' => env('AUTH_PASSWORD_TIMEOUT', 10800),

];
