<?php

namespace App\Repositories\V1\Users;

use App\Enums\UserTypeEnum;
use App\Models\User;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlUserRepository implements UserRepositoryInterface
{
    public function first(array $conditions): ?User
    {
        return User::query()
            ->where('type', '=', UserTypeEnum::CUSTOMER->value)
            ->where($conditions)->first();
    }

    public function update(int $userId, array $data): bool
    {
        return User::where('id', $userId)
            ->where('type', '=', UserTypeEnum::CUSTOMER->value)
            ->update($data);
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(User::query())
            ->where('type', '=', UserTypeEnum::CUSTOMER->value)
            ->orderByDesc('id')->paginate($limit);
    }

    public function getById(int $id): User
    {
        return User::query()
            ->where('type', '=', UserTypeEnum::CUSTOMER->value)
            ->findOrFail($id);
    }
}
