<?php

namespace App\Repositories\V1\Tags;

use App\Models\Tag;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

interface TagRepositoryInterface
{
    public function first(array $conditions): ?Tag;

    public function update(int $id, array $data): bool;

    public function index(Utility $utility, int $limit): LengthAwarePaginator;

    public function create(array $data): Tag;

    public function getById(int $id): Tag;
}
