<?php

namespace App\Repositories\V1\Tags;

use App\Models\Tag;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlTagRepository implements TagRepositoryInterface
{
    public function first(array $conditions): ?Tag
    {
        return Tag::query()->where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return Tag::where('id', $id)->update($data);
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(Tag::query())
            ->orderByDesc('id')->paginate($limit);
    }

    public function create(array $data): Tag
    {
        return Tag::query()->create($data);
    }

    public function getById(int $id): Tag
    {
        return Tag::query()->findOrFail($id);
    }
}
