<?php

namespace App\Repositories\V1\States;

use App\Models\State;
use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Pagination\LengthAwarePaginator;



class MysqlStateRepository implements StateRepositoryInterface
{
    public function first(array $conditions): ?State
    {
        return State::query()->where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return State::where('id', $id)->update($data);
    }

    public function index(Utility $utility): Collection
    {
        return $utility->applyOnBuilder(State::query())
            ->orderByDesc('id')->get();
    }
    
    public function indexPaginated(Utility $utility, int $perPage = 15): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(State::query())
            ->orderByDesc('id')
            ->paginate($perPage);
    }


    public function create(array $data): State
    {
        return State::query()->create($data);
    }

    public function getById(int $id): State
    {
        return State::query()->findOrFail($id);
    }
}
