<?php

namespace App\Repositories\V1\Sliders;

use App\Models\Slider;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlSliderRepository implements SliderRepositoryInterface
{
    public function first(array $conditions): ?Slider
    {
        return Slider::query()->where($conditions)->first();
    }

    public function update(int $id, array $data): bool
    {
        return Slider::where('id', $id)->update($data);
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(Slider::query())
            ->orderByDesc('id')->paginate($limit);
    }

    public function create(array $data): Slider
    {
        return Slider::query()->create($data);
    }

    public function getById(int $id): Slider
    {
        return Slider::query()->findOrFail($id);
    }
}
