<?php

namespace App\Repositories\V1\Settings;

use App\Models\Setting;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

class MysqlSettingRepository implements SettingRepositoryInterface
{
    public function first(array $conditions): ?Setting
    {
        return Setting::query()->where($conditions)->first();
    }

    public function updateOrCreate(array $where, array $data): bool
    {
        Setting::updateOrCreate($where, $data);
        return true;
    }

    public function index(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $utility->applyOnBuilder(Setting::query())
            ->orderByDesc('id')->paginate($limit);
    }

    public function getById(int $id): Setting
    {
        return Setting::query()->findOrFail($id);
    }
}
